/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.pathfinding;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Target;

public class ClimberNodeEvaluator
extends NodeEvaluator {
    public Node m_7171_() {
        return super.m_5676_(Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_), Mth.m_14107_((double)(this.f_77313_.m_20191_().f_82289_ + 0.5)), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_));
    }

    public Target m_7568_(double p_77322_, double p_77323_, double p_77324_) {
        return this.m_230615_(super.m_5676_(Mth.m_14107_((double)p_77322_), Mth.m_14107_((double)p_77323_), Mth.m_14107_((double)p_77324_)));
    }

    public int m_6065_(Node[] p_77483_, Node p_77484_) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node node = this.m_5676_(p_77484_.f_77271_ + direction.m_122429_(), p_77484_.f_77272_ + direction.m_122430_(), p_77484_.f_77273_ + direction.m_122431_());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            p_77483_[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            Direction direction2 = direction1.m_122427_();
            Node node1 = this.m_5676_(p_77484_.f_77271_ + direction1.m_122429_() + direction2.m_122429_(), p_77484_.f_77272_, p_77484_.f_77273_ + direction1.m_122431_() + direction2.m_122431_());
            if (!this.isDiagonalNodeValid(node1, (Node)map.get(direction1), (Node)map.get(direction2))) continue;
            p_77483_[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node node) {
        boolean foundBlock = false;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (this.isAir(node.f_77271_ + x, node.f_77272_ + y, node.f_77273_ + z)) continue;
                    foundBlock = true;
                }
            }
        }
        return node != null && foundBlock && this.f_77312_.m_8055_(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_)).m_60795_() && !node.f_77279_;
    }

    public boolean isAir(double x, double y, double z) {
        return this.f_77312_.m_8055_(new BlockPos(x, y, z)).m_60795_();
    }

    protected boolean isDiagonalNodeValid(@Nullable Node p_192964_, @Nullable Node p_192965_, @Nullable Node p_192966_) {
        return this.isNodeValid(p_192964_) && p_192965_ != null && p_192965_.f_77281_ >= 0.0f && p_192966_ != null && p_192966_.f_77281_ >= 0.0f;
    }

    public BlockPathTypes m_7209_(BlockGetter p_77337_, int p_77338_, int p_77339_, int p_77340_, Mob p_77341_, int p_77342_, int p_77343_, int p_77344_, boolean p_77345_, boolean p_77346_) {
        return BlockPathTypes.OPEN;
    }

    public BlockPathTypes m_8086_(BlockGetter p_77333_, int p_77334_, int p_77335_, int p_77336_) {
        return BlockPathTypes.OPEN;
    }
}

